//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Reflection;
using System.Security.Permissions;

namespace TypeSampler
{
	// Zdefiniowany przez uytkownika typ wartoci.
	public struct MyStruct
	{
		public int a;
		public int b;
	}

	public enum Sample { Sample1, Sample2, Sample3};

	// Interfejsy
	public interface IMyInterface
	{
		// Metoda zwraca tablic
		string [] MyInterfaceMethod();
	}
	public interface IYourInterface
	{
		void YourInterfaceMethod(MyDelegate callback);
	}

	// Delegat
	public delegate void MyDelegate(string msg);

	// Klasa
	[Serializable]
	public class MyClass: IMyInterface, IYourInterface
	{
		// Pola
		private int myInt;
		private string myString;
		private Sample mySample;

		// Konstruktor
		public MyClass()
		{
			myInt = 0;
			myString = Assembly.GetCallingAssembly().FullName;
		}
		// Metoda
		public MyStruct MyMethod(int a, int b)
		{
			MyStruct ms = new MyStruct();
			ms.a = a;
			ms.b = b;
			return ms;
		}

		// Implementacje interfejsu
		public string [] MyInterfaceMethod()
		{
			string [] returnArray = new string[] {"Ten", "tekst", "zosta", "zwrcony", "z", "MyMethod", "w", "IMyInterface"};
			return returnArray;
		}

		public void YourInterfaceMethod(MyDelegate yourCallback)
		{
			yourCallback("Hej ty!");
		}

		// Waciwo
		public int MyInt
		{
			get
			{
				return myInt;
			}
			set
			{
				myInt = value;
			}
		}

		// Inna waciwo
		public string MyString
		{
			get
			{
				return myString;
			}
		}

		// Jeszcze inna waciwo
		public Sample MyEnum
		{
			get
			{
				return mySample;
			}
			set
			{
				mySample = value;
			}
		}
	}
}
